// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/net_address.mojom
//

package org.chromium.mojom.mojo;

public final class NetAddress extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 32;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public int family;
    public NetAddressIPv4 ipv4;
    public NetAddressIPv6 ipv6;

    private NetAddress(int version) {
        super(STRUCT_SIZE, version);
        family = (int) NetAddressFamily.UNSPECIFIED;
    }

    public NetAddress() {
        this(0);
    }

    public static NetAddress deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static NetAddress decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        NetAddress result = new NetAddress(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.family = decoder0.readInt(8);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, true);
            result.ipv4 = NetAddressIPv4.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, true);
            result.ipv6 = NetAddressIPv6.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(family, 8);
        encoder0.encode(ipv4, 16, true);
        encoder0.encode(ipv6, 24, true);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        NetAddress other = (NetAddress) object;
        if (this.family != other.family)
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.ipv4, other.ipv4))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.ipv6, other.ipv6))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(family);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(ipv4);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(ipv6);
        return result;
    }
}

